' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports Microsoft.VisualBasic

Public Class DalHelpers

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy DalHelpers.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Formatuje nazw parametrw obiektu Command w oparciu o dostawc danych uytego w aplikacji.
  ''' </summary>
  ''' <param name="paramName">Nazwa parametru przesanego do obiektu Command.</param>
  ''' <returns>Co w rodzaju @parameterName dla bazy danych SQL Server oraz ?, w przypadku Microsoft Access.</returns>
  ''' <exception cref="NotSupportedException">Zgaszany, gdy typ biecego doatawcy jest rny od SqlClient lub OleDb.</exception>
  Public Shared Function ReturnCommandParamName( _
      ByVal paramName As String) As String
    Dim returnValue As String = String.Empty
    Select Case AppConfiguration.ConnectionStringSettings.ProviderName.ToLower()
      Case "system.data.sqlclient"
        returnValue = "@" & paramName
      Case "system.data.oledb"
        returnValue = "?"
      Case Else
        Throw New NotSupportedException("Dostawca danych " & _
            AppConfiguration.ConnectionStringSettings.ProviderName & " nie jest obsugiwany")
    End Select
    Return returnValue
  End Function

End Class
